/** @file   SentryFireballBullet.h
 * @brief   Declaration of SentryFireballBullet class.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:42 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_SENTRYFIREBALLBULLET_H
#define H_WWW_SENTRYFIREBALLBULLET_H

#include "bullet.h"

namespace WeWantWar {

/** @class  SentryFireballBullet
 * @brief   Represents the fireball shot by SentryGun
 * @author  Tomi Lamminsaari
 *
 */
class SentryFireballBullet : public Bullet
{
public:

  ///
  /// Constants, datatypes and static methods
  /// =======================================

  ///
  /// Constructors, destructor and operators
  /// ======================================

  /** Default constructor.
   * @param   aShooter          Pointer to GameObject who shot this.
   * @param   aPos              Starting position.
   */
  SentryFireballBullet( GameObject* aShooter, const eng2d::Vec2D& aPos );

  /** Destructor
   */
  ~SentryFireballBullet();

private:
  
  /** Copy constructor
   * @param   aAnother          Reference to another SentryFireballBullet
   */
  SentryFireballBullet( const SentryFireballBullet& aAnother );

  /** An assignment operator
   * @param   aAnother          Reference to another SentryFireballBullet
   * @return  Reference to this object.
   */
  SentryFireballBullet& operator= ( const SentryFireballBullet& aAnother );

public:

  ///
  /// Inherited methods
  /// =================

  /** Draws this bullet.
   * @param   aBitmap           Target bitmap.
   */
  virtual void redraw( BITMAP* aBitmap ) const;
  

};

};  // end of namespace

#endif
